/************************************************************************\
	Derived from the source for the GNU uuencode and uudecode utilities.
	Copyright (C) 1996 Les R. Titze

	UUEncTxAsync ( binaryData, binSize, binOff, txFunc );

	local myTxFunc := func ( outData, newOff )
		begin
		_v_OutStrBuff := outData;
		:TxOutBuff();
		return true;	// "keepGoing" - nil = async return from UUEncTxAsync
		end;

\************************************************************************/

#include "objects.h"
#include "NewtonScript.h"

// ENC is the basic 1 character encoding function to make a char printing.
#define ENC(Char) (trans_ptr[(Char) & 0x3F])

static void _uuencodeStdTxAsync ( void * srcBinP, long binSize, long binOff, RefArg txFunc );

extern "C" Ref UUEncTxAsync ( RefArg rcvr, RefArg binObj, RefArg binSize, RefArg binOff, RefArg txFunc )
{
	if ( !IsBinary(binObj) )
		ThrowBadTypeWithFrameData ( -48408, binObj );	// expected a binary object

	if ( !IsInt(binSize) )
		ThrowBadTypeWithFrameData ( -48406, binSize );	// expected an integer

	if ( !IsInt(binOff) )
		ThrowBadTypeWithFrameData ( -48406, binOff );	// expected an integer

	if ( !IsFunction(txFunc) )
		ThrowBadTypeWithFrameData ( -48411, txFunc );	// expected a function

	long sz = RefToInt ( binSize );
	long of = RefToInt ( binOff );

	WITH_LOCKED_BINARY ( binObj, srcP )

		_uuencodeStdTxAsync ( srcP, sz, of, txFunc );

	END_WITH_LOCKED_BINARY(binObj)

	return MakeBoolean ( 0 );
}


void _uuencodeStdTxAsync ( void * srcBinP, long binSize, long binOff, RefArg txFunc )
{
	const char trans_ptr[64] =		// referenced in "ENC" macro (above)
	{
		'`', '!', '"', '#', '$', '%', '&', '\'',
		'(', ')', '*', '+', ',', '-', '.', '/',
		'0', '1', '2', '3', '4', '5', '6', '7',
		'8', '9', ':', ';', '<', '=', '>', '?',
		'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G',
		'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
		'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
		'X', 'Y', 'Z', '[', '\\', ']', '^', '_'
	};

	void	* srcFinirP = (void *)( (long)srcBinP + binSize );

	short	outStr[100];

	register short	* resultP;
	register char	* p;
	register long	ch;
	register unsigned long n;

	unsigned long srcOff = binOff;	// was 0 in non-async

	while(1)
	{
		void * startP = (void *)( (unsigned long)srcBinP + srcOff );
		void * finirP = (void *)( (unsigned long)startP + 45 );

		if ( finirP > srcFinirP )
			finirP = srcFinirP;

		n = (unsigned long)finirP - (unsigned long)startP;
		srcOff = srcOff + n;

		if ( n == 0 )		// done
			break;

		resultP = outStr;		// char out pointer

		*resultP++ = ENC ( n );

		for ( p = (char *)startP; n > 2; n -= 3, p += 3 )
		{
			*resultP++ = ENC ( *p >> 2 );

			*resultP++ = ENC ( ((*p << 4) & 0x30) | ((p[1] >> 4) & 0x0F ) );

			*resultP++ = ENC ( ((p[1] << 2) & 0x3C) | ((p[2] >> 6) & 0x03) );

			*resultP++ = ENC ( p[2] & 0x3F );
		}

		if ( n != 0 )
			break;

		*resultP++ = 13;	// <CR>
		*resultP++ = 10;	// <LF>
		*resultP++ = 0;		// end of string

		Ref keepGoing = 
			NSCall ( txFunc, MakeString ( (UniChar *)outStr ), MakeInt ( srcOff ) );

		if ( ISNIL ( keepGoing ) )
		{
			return;
		}

		resultP = outStr;		// reset the char out pointer
	}

	if ( n != 0 )
	{
		char c1 = *p;
		char c2 = n == 1 ? 0 : p[1];

		*resultP++ = ENC ( c1 >> 2 );

		*resultP++ = ENC ( ((c1 << 4) & 0x30) | ((c2 >> 4) & 0x0F) );

		if (n == 1)
			ch = ENC ('\0');
		else
		{
			ch = (c2 << 2) & 0x3C;
			ch = ENC (ch);
		}
		*resultP++ = ENC ( ch );

		*resultP++ = ENC ('\0');

		*resultP++ = 13;	// <CR>
		*resultP++ = 10;	// <LF>
	}

	*resultP++ = ENC ( '\0' );

	*resultP++ = 13;	// <CR>
	*resultP++ = 10;	// <LF>
	*resultP++ = 0;		// end of string

	// for this final one, we can ignore the result
	NSCall ( txFunc, MakeString ( (UniChar *)outStr ), MakeInt ( -1 ) );
}
